<?php


require_once("home.php"); // loading home controller

/**
* @category controller
* class Admin
*/

class admin extends Home
{

    public $user_id;
    public $download_id;
    

	/**
    * load constructor
    * @access public
    * @return void
    */
    
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('logged_in') != 1) {
            redirect('home/login_page', 'location');
        }

        $this->load->helper('form');
        $this->load->library('upload');
        $this->load->library('image_lib');
        $this->upload_path = realpath(APPPATH . '../upload');
        $this->user_id=$this->session->userdata('user_id');
        $this->download_id=$this->session->userdata('download_id');
    }


    /**
    * index method
    * @access public
    * @return void
    */

    public function index()
    {
        if ($this->session->userdata('logged_in') == 1 && $this->session->userdata('user_type') != 'Admin') {
            redirect('admin/member_panel', 'location');
        }
        $this->user_management();
    }

    /**
    * dashboard method to show statistics
    * @access public
    * @return void
    */

    public function member_panel()
    {
        if ($this->session->userdata('logged_in') == 1 && $this->session->userdata('user_type') != 'Member') {
            redirect('admin/index', 'location');
        }
        // $data['body'] = 'admin/member_panel';
        // $this->_viewcontroller($data);
        $this->website_search();
    }


    /**
    * user_management method to manage user
    * @access public
    * @return void
    */

    public function user_management()
    {
        $this->load->database();
        $this->load->library('grocery_CRUD');
        $crud = new grocery_CRUD();
        $crud->set_theme('flexigrid');
        $crud->set_table('users');
        $crud->order_by('id');
        $crud->where('deleted', '0');
        $crud->set_subject('User');

        $crud->fields('name', 'email', 'mobile', 'password', 'address', 'user_type', 'status');

        $crud->edit_fields('name', 'email', 'mobile', 'address', 'user_type', 'status');

        $crud->add_fields('name', 'email', 'mobile', 'password', 'address', 'user_type', 'status');

        $crud->required_fields('name', 'email', 'mobile', 'password', 'address', 'user_type', 'status');

        $crud->columns('name', 'email', 'mobile', 'address', 'status', 'user_type');

        $crud->display_as('name', 'Name');
        $crud->display_as('email', 'Email');
        $crud->display_as('mobile', 'Mobile');
        $crud->display_as('address', 'Address');
        $crud->display_as('status', 'Status');
        $crud->display_as('user_type', 'User Type');

       
        $crud->set_rules("email","Email",'callback_unique_email_check['.$this->uri->segment(4).']');


        $images_url = base_url("plugins/grocery_crud/themes/flexigrid/css/images/password.png");
        $crud->add_action('Change User Password', $images_url, 'admin/change_user_password');

        $crud->callback_column('status', array($this, 'status_display_crud'));
        $crud->callback_field('status', array($this, 'status_field_crud'));

        $crud->callback_after_insert(array($this, 'encript_password'));
       
        
        $crud->unset_read();
        $crud->unset_print();
        $crud->unset_export();

        $output = $crud->render();
        $data['output']=$output;
        $data['page_title'] = 'User Management';
        $data['crud']=1;

        $this->_viewcontroller($data);
    }

    function unique_email_check($str, $edited_id)
    {
        $email= strip_tags(trim($this->input->post('email',TRUE)));
        if($email==""){
            $s="<b>Email</b> is required.";
            $this->form_validation->set_message('unique_email_check', $s);
            return FALSE;
        }
        
        if(!isset($edited_id) || !$edited_id)
            $where=array("email"=>$email);
        else        
            $where=array("email"=>$email,"id !="=>$edited_id);
        
        
        $is_unique=$this->basic->is_unique("users",$where,$select='');
        
        if (!$is_unique) {
             $s="<b>Email</b> is already used.";
            $s="<b>".$this->lang->line("email")."</b> ".$s;
            $this->form_validation->set_message('unique_email_check', $s);
            return FALSE;
            }
                
        return TRUE;
    }

    /**
    * method to display status
    * @access public
    * @param int
    * @param array
    * @return string
    */


    public function status_display_crud($value, $row)
    {
        if ($value == 1) {
            return "<span class='label label-success'>Active</sapn>";
        } else {
            return "<span class='label label-warning'>Inactive</sapn>";
        }
    }

    /**
    * method to status display
    * @access public
    * @param int
    * @param array
    * @return string
    */

    public function status_field_crud($value, $row)
    {
        if ($value == '') {
            $value = 1;
        }
        return form_dropdown('status', array(0 => 'Inactive', 1 => 'Active'), $value, 'class="form-control" id="field-status"');
    }


    /**
    * method to encrypt password
    * @access public    
    * @param array
    * @param int
    * @return true
    */

    public function encript_password($post_array, $primary_key)
    {
        $id = $$primary_key;
        $where = array('id'=>$id);
        $password = md5($post_array['password']);
        $table = 'users';
        $data = array('password'=>$password);
        $this->basic->update_data($table, $where, $data);
        return true;
    }


    /**
    * method to change user password
    * @access public       
    * @param int
    * @return void
    */

    public function change_user_password($id)
    {
        $this->session->set_userdata('change_user_password_id', $id);

        $table = 'users';
        $where['where'] = array('id' => $id);

        $info = $this->basic->get_data($table, $where);

        $data['user_name'] = $info[0]['name'];

        $data['body'] = 'admin/change_user_password';
        $data['page_title'] = "Password Change";
        $this->_viewcontroller($data);
    }

    /**
    * method to change user password action
    * @access public       
    * @return void
    */

    public function change_user_password_action()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }
        $id = $this->session->userdata('change_user_password_id');
        // $this->session->unset_userdata('change_member_password_id');
        if ($_POST) {
            $this->form_validation->set_rules('password', '<b>Password</b>', 'trim|required');
            $this->form_validation->set_rules('confirm_password', '<b>Confirm Password</b>', 'trim|required|matches[password]');
        }
        if ($this->form_validation->run() == false) {
            $this->change_user_password($id);
        } else {
            $new_password = $this->input->post('password', true);
            $new_confirm_password = $this->input->post('confirm_password', true);

            $table_change_password = 'users';
            $where_change_passwor = array('id' => $id);
            $data = array('password' => md5($new_password));
            $this->basic->update_data($table_change_password, $where_change_passwor, $data);

            $where['where'] = array('id' => $id);
            $mail_info = $this->basic->get_data('users', $where);
            
            $name = $mail_info[0]['name'];
            $to = $mail_info[0]['email'];
            $password = $new_password;

            $subject = 'Change Password Notification';
            $mask = $this->config->item('product_name');
            $from = $this->config->item('institute_email');
            $url = site_url();

            $message = "Dear {$name}, Your <a href='".$url."'>{$mask}</a> password has been changed. Your new password is: {$password}. Thank you.";
            $this->_mail_sender($from, $to, $subject, $message, $mask);
            $this->session->set_flashdata('success_message', 1);
                // return $this->config_member();
            redirect('admin/user_management', 'location');
        }
    }

    /**
    * method to load website search view page
    * @access public       
    * @return void
    */

    public function website_search()
    {
        $data['body'] = 'admin/website_search';
        $data['page_title'] = 'Crawl Website';
        $this->_viewcontroller($data);
    }


    /**
    * method to load website search data 
    * @access public      
    * @return void
    */
    public function website_search_data()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }
            // setting variables for pagination
        $page = isset($_POST['page']) ? intval($_POST['page']) : 15;
        $rows = isset($_POST['rows']) ? intval($_POST['rows']) : 5;
        $sort = isset($_POST['sort']) ? strval($_POST['sort']) : 'domain.id';
        $order = isset($_POST['order']) ? strval($_POST['order']) : 'DESC';

        $domain_name      = trim($this->input->post("domain_name", true));
        $user_name      = trim($this->input->post("user_name", true));
        $from_date = trim($this->input->post('from_date', true));
        if($from_date)
            $from_date = date('Y-m-d', strtotime($from_date));

        $to_date = trim($this->input->post('to_date', true));
        if($to_date)
            $to_date = date('Y-m-d', strtotime($to_date));


            // setting a new properties for $is_searched to set session if search occured
        $is_searched = $this->input->post('is_searched', true);


        if ($is_searched) {
            // if search occured, saving user input data to session. name of method is important before field

            $this->session->set_userdata('website_search_domain_name',      $domain_name);
            $this->session->set_userdata('website_search_user_name',      $user_name);
            $this->session->set_userdata('website_search_from_date',        $from_date);
            $this->session->set_userdata('website_search_to_date',        $to_date);
            //	$this->session->set_userdata('book_list_category',$category_id);
        }

            // saving session data to different search parameter variables

        $search_domain_name      = $this->session->userdata('website_search_domain_name');
        $search_user_name      = $this->session->userdata('website_search_user_name');
        $search_from_date      = $this->session->userdata('website_search_from_date');
        $search_to_date      = $this->session->userdata('website_search_to_date');
       //	$search_category=$this->session->userdata('book_list_category');

        // creating a blank where_simple array
        $where_simple=array();

      // trimming data

        
        if ($search_domain_name) {
            $where_simple['domain.domain_name like ']    = "%".$search_domain_name."%";
        }

        if ($search_user_name) {
            $where_simple['users.name like']   = "%".$search_user_name."%";
        }

        if ($search_from_date) {
            if ($search_from_date != '1970-01-01') {
                $where_simple["Date_Format(domain.last_scraped_time,'%Y-%m-%d') >="]= $search_from_date;
            }
        }
        if ($search_to_date) {
            if ($search_to_date != '1970-01-01') {
                $where_simple["Date_Format(domain.last_scraped_time,'%Y-%m-%d') <="]=$search_to_date;
            }
        }
        $where_simple['domain.user_id'] = $this->user_id;
        
        $where  = array('where'=>$where_simple);

        $order_by_str=$sort." ".$order;

        $offset = ($page-1)*$rows;
        $result = array();

        $table = "domain";
        $select = array('email.id','domain.id as domain_id','count(email.found_email) as found_email','domain.domain_name','domain.last_scraped_time','domain.is_available');
        $join = array(
            "email" => "email.domain_id=domain.id,left",
            );

        $info = $this->basic->get_data($table, $where, $select, $join, $limit=$rows, $start=$offset, $order_by=$order_by_str, $group_by='domain.id');



        $total_rows_array = $this->basic->count_row($table, $where, $count="domain.id", $join, $group_by='domain.id');
        

        $total_result = $total_rows_array[0]['total_rows'];

        echo convert_to_grid_data($info, $total_result);
    }


    /**
    * method to view website wise details
    * @access public      
    * @return void
    */
    public function website_wise_details()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $domain_id = trim($this->input->post('domain_id'));

        $where['where'] = array('domain.id'=>$domain_id);
        $table = 'domain';
        $join = array("email" => "email.domain_id=domain.id,left");

        $info = $this->basic->get_data($table, $where, $select ='', $join);

        $str = "<h3 class = 'text-info' style='margin-top:0px !important'>Emails from {$info[0]['domain_name']}</h3>
		<table class='table table-hover'>
		<tr>
			<th>SL</th>
			<th>Email Address</th>			
		</tr>";

        $row_count = 1;

        foreach ($info as $detail) {
            $str .= "<tr><td>".$row_count."</td><td>".$detail['found_email']."</td></tr>";
            $row_count++;
        }
        $str .= "</table>";

        echo $str;
    }

    /**
    * method to perform website wise download
    * @access public  
    * @return void
    */

    public function website_wise_download()
    {
        $table = 'domain';
        $join = array(
            "email" => "email.domain_id=domain.id,left",
            "users" => "email.user_id = users.id,letf"
            );

        $selected_grid_data = $this->input->post('info', true);
        $domain_names = json_decode($selected_grid_data, true);
        $domain_names_array = array();
        foreach ($domain_names as  $value) {
            $domain_names_array[] = $value['domain_name'];
        }
        $where['where_in'] = array('domain_name' => $domain_names_array);

        $info = $this->basic->get_data($table, $where, $select ='', $join, $limit='', $start=null, $order_by='domain_name asc');

        $fp = fopen("download/report/website_wise_email_{$this->user_id}_{$this->download_id}.csv", "w");
        $head=array("Domain Name","User Name","Last Scraped Time", "Email");
        fputcsv($fp, $head);
        $write_info = array();

        foreach ($info as  $value) {
            $write_info['domain_name'] = $value['domain_name'];
            $write_info['user_name'] = $value['name'];
            $write_info['last_scraped_time'] = $value['last_scraped_time'];
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
        }

        fclose($fp);
        $file_name = "download/report/website_wise_email_{$this->user_id}_{$this->download_id}.csv";
        echo $file_name;
    }

    /**
    * method to search url view page
    * @access public        
    * @return true
    */

    public function url_search()
    {
        $data['body'] = 'admin/url_search';
        $data['page_title'] = 'Crawl URL';
        $this->_viewcontroller($data);
    }

     /**
    * method to status display data
    * @access public    
    * @return void
    */
    public function url_search_data()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }
            // setting variables for pagination
        $page    = isset($_POST['page']) ? intval($_POST['page']) : 15;
        $rows    = isset($_POST['rows']) ? intval($_POST['rows']) : 5;
        $sort    = isset($_POST['sort']) ? strval($_POST['sort']) : 'email.id';
        $order    = isset($_POST['order']) ? strval($_POST['order']) : 'ASC';

        $url        =   trim($this->input->post("url", true));
        $user_name  =    trim($this->input->post("user_name", true));

        $from_date    =    trim($this->input->post('from_date', true));
        if($from_date)
            $from_date    =    date('Y-m-d', strtotime($from_date));

        $to_date    =    trim($this->input->post('to_date', true));
        if($to_date)
            $to_date    =    date('Y-m-d', strtotime($to_date));


            // setting a new properties for $is_searched to set session if search occured
        $is_searched = $this->input->post('is_searched', true);


        if ($is_searched) {
            // if search occured, saving user input data to session. name of method is important before field

            $this->session->set_userdata('url_search_url', $url);
            $this->session->set_userdata('url_search_user_name', $user_name);
            $this->session->set_userdata('url_search_from_date', $from_date);
            $this->session->set_userdata('url_search_to_date', $to_date);
            //	$this->session->set_userdata('book_list_category',$category_id);
        }

            // saving session data to different search parameter variables

        $search_url          = $this->session->userdata('url_search_url');
        $search_user_name    = $this->session->userdata('url_search_user_name');
        $search_from_date    = $this->session->userdata('url_search_from_date');
        $search_to_date      = $this->session->userdata('url_search_to_date');
       //	$search_category=$this->session->userdata('book_list_category');

        // creating a blank where_simple array
        $where_simple=array();

      // trimming data

        
        if ($search_url) {
            $where_simple['url.url_name like ']    = "%".$search_url."%";
        }

        if ($search_user_name) {
            $where_simple['users.name like']   = "%".$search_user_name."%";
        }

        if ($search_from_date) {
            if ($search_from_date != '1970-01-01') {
                $where_simple["Date_Format(url.last_scraped_time,'%Y-%m-%d') >="]= $search_from_date;
            }
        }
        if ($search_to_date) {
            if ($search_to_date != '1970-01-01') {
                $where_simple["Date_Format(url.last_scraped_time,'%Y-%m-%d') <="]=$search_to_date;
            }
        }

        $where_simple['url.user_id'] = $this->user_id;
        $where  = array('where'=>$where_simple);

        $order_by_str=$sort." ".$order;

        $offset = ($page-1)*$rows;
        $result = array();

        $table = "url";
        $select = array('email.id','url.id as url_id','count(email.found_email) as found_email','url.url_name','url.last_scraped_time','url.is_available');
        $join = array(
            "email" => "email.url_id=url.id,left"
            );

        $info = $this->basic->get_data($table, $where, $select, $join, $limit=$rows, $start=$offset, $order_by=$order_by_str, $group_by='url.id');

        $total_rows_array = $this->basic->count_row($table, $where, $count="url.id", $join, $group_by='url.id');

        $total_result = $total_rows_array[0]['total_rows'];

        echo convert_to_grid_data($info, $total_result);
    }

     /**
    * method to load url wise detaisl
    * @access public  
    * @return void
    */

    public function url_wise_details()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $url_id = trim($this->input->post('url_id'));

        $where['where'] = array('url.id'=>$url_id);
        $table = 'url';
        $join = array("email" => "email.url_id=url.id,left");

        $info = $this->basic->get_data($table, $where, $select ='', $join);

        $str = "<h3 class = 'text-center text-info'>URL: {$info[0]['url_name']}</h3>
		<table class='table table-hover'>
		<tr>
			<th>SL</th>
			<th>Email Address</th>			
		</tr>";

        $row_count = 1;

        foreach ($info as $detail) {
            if (!empty($detail['found_email'])) {
                $str .= "<tr><td>".$row_count."</td><td>".$detail['found_email']."</td></tr>";
                $row_count++;
            }
        }
        $str .= "</table>";

        echo $str;
    }


     /**
    * method to url wise download
    * @access public   
    * @return void
    */
    public function url_wise_download()
    {
        $table = 'url';
        $join = array("email" => "email.url_id=url.id,left","users" => "email.user_id = users.id,left");

        $selected_grid_data = $this->input->post('info', true);
        $url_names = json_decode($selected_grid_data, true);
        $url_names_array = array();
        foreach ($url_names as  $value) {
            $url_names_array[] = $value['url_name'];
        }
        $where['where_in'] = array('url_name' => $url_names_array);

        $info = $this->basic->get_data($table, $where, $select ='', $join, $limit='', $start=null, $order_by='url_name asc');

        $fp = fopen("download/report/url_wise_email_{$this->user_id}_{$this->download_id}.csv", "w");
        $head=array("URL Name","Last Scraped Time", "User Name", "Email");
        fputcsv($fp, $head);
        $write_info = array();

        foreach ($info as  $value) {
            $write_info['url_name'] = $value['url_name'];
            $write_info['last_scraped_time'] = $value['last_scraped_time'];
            $write_info['user_name'] = $value['name'];
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
        }

        fclose($fp);
        $file_name = "download/report/url_wise_email_{$this->user_id}_{$this->download_id}.csv";
        echo $file_name;
    }

     /**
    * method to search search engine
    * @access public    
    * @return string
    */

    public function searchengine_search()
    {
        $data['body'] = 'admin/searchengine_search';
        $data['page_title'] = 'Searchengine Search';
        $data['social_network'] = $this->get_social_networks();
        $data['email_provider'] = $this->get_email_providers();
        $data['searh_engine'] = $this->get_searche_engines();
        $this->_viewcontroller($data);
    }


     /**
    * method to load search engine search data
    * @access public    
    * @return void
    */
    public function searchengine_search_data()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }
        $page    = isset($_POST['page']) ? intval($_POST['page']) : 15;
        $rows    = isset($_POST['rows']) ? intval($_POST['rows']) : 5;
        $sort    = isset($_POST['sort']) ? strval($_POST['sort']) : 'search_engine_search.id';
        $order    = isset($_POST['order']) ? strval($_POST['order']) : 'DESC';

        $keyword            =   trim($this->input->post("keyword", true));
        $user_name          =    trim($this->input->post("user_name", true));
        $searchengine          =    trim($this->input->post("searchengine", true));
        $social_network     =    trim($this->input->post("social_network", true));

        $from_date            =    trim($this->input->post('from_date', true));
        if($from_date)
            $from_date            =    date('Y-m-d', strtotime($from_date));


        $to_date            =    trim($this->input->post('to_date', true));
        if($to_date)
            $to_date            =    date('Y-m-d', strtotime($to_date));


            // setting a new properties for $is_searched to set session if search occured
        $is_searched = $this->input->post('is_searched', true);


        if ($is_searched) {
            // if search occured, saving user input data to session. name of method is important before field

            $this->session->set_userdata('searchengine_search_keyword', $keyword);
            $this->session->set_userdata('searchengine_search_user_name', $user_name);
            $this->session->set_userdata('searchengine_search_searchengine', $searchengine);
            $this->session->set_userdata('searchengine_search_social_network', $social_network);
            $this->session->set_userdata('searchengine_search_from_date', $from_date);
            $this->session->set_userdata('searchengine_search_to_date', $to_date);
            //	$this->session->set_userdata('book_list_category',$category_id);
        }

            // saving session data to different search parameter variables

        $search_keyword         = $this->session->userdata('searchengine_search_keyword');
        $search_user_name         = $this->session->userdata('searchengine_search_user_name');
        $search_searchengine     = $this->session->userdata('searchengine_search_searchengine');
        $search_social_network  = $this->session->userdata('searchengine_search_social_network');
        $search_from_date        = $this->session->userdata('searchengine_search_from_date');
        $search_to_date          = $this->session->userdata('searchengine_search_to_date');
       //	$search_category=$this->session->userdata('book_list_category');

        // creating a blank where_simple array
        $where_simple=array();

      // trimming data

        
        if ($search_keyword) {
            $where_simple['search_engine_search.search_keyword like ']    = "%".$search_keyword."%";
        }

        if ($search_user_name) {
            $where_simple['users.name like ']    = "%".$search_user_name."%";
        }

        if (!empty($search_searchengine)) {
            $where_simple['search_engine_search.search_engine_name like ']    = "%".$search_searchengine."%";
        }

        if ($search_social_network) {
            $where_simple['search_engine_search.search_in like ']    = "%".$search_social_network."%";
        }

        if ($search_from_date) {
            if ($search_from_date != '1970-01-01') {
                $where_simple["Date_Format(search_engine_search.last_scraped_time,'%Y-%m-%d') >="]= $search_from_date;
            }
        }
        if ($search_to_date) {
            if ($search_to_date != '1970-01-01') {
                $where_simple["Date_Format(search_engine_search.last_scraped_time,'%Y-%m-%d') <="]=$search_to_date;
            }
        }

        $where_simple['search_engine_search.user_id'] = $this->user_id;
        $where  = array('where'=>$where_simple);

        $order_by_str=$sort." ".$order;

        $offset = ($page-1)*$rows;
        $result = array();

        $table = "search_engine_search";
        $select = array('email.id','search_engine_search.id as search_engine_url_id','count(email.found_email) as found_email','search_engine_search.search_engine_name','search_engine_search.last_scraped_time','search_engine_search.search_in','search_engine_search.search_keyword');
        $join = array(
            "email"        => "email.search_engine_url_id	 	= 	search_engine_search.id,left"
            );

        $info = $this->basic->get_data($table, $where, $select, $join, $limit=$rows, $start=$offset, $order_by=$order_by_str, $group_by='search_engine_search.id');



        $total_rows_array = $this->basic->count_row($table, $where, $count="search_engine_search.id", $join, $group_by='search_engine_search.id');

        $total_result = $total_rows_array[0]['total_rows'];

        echo convert_to_grid_data($info, $total_result);
    }


     /**
    * method to view search engine wise details
    * @access public    
    * @return void
    */
    public function searchengine_wise_details()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $search_engine_url_id = trim($this->input->post('search_engine_url_id', true));

        $where['where'] = array('search_engine_search.id'=>$search_engine_url_id);
        $table = 'search_engine_search';
        $join = array(
            "email"        => "email.search_engine_url_id	 	= 	search_engine_search.id,left",
            "searh_engine"  => "searh_engine.search_engine_name  =	search_engine_search.search_engine_name,left"
            );

        $info = $this->basic->get_data($table, $where, $select ='', $join);

        $str = "<h3 class = 'text-center text-info'>Email from {$info[0]['search_engine_name']}</h3>
		<table class='table table-hover'>
		<tr>
			<th>SL</th>
			<th>Email Address</th>			
		</tr>";

        $row_count = 1;

        foreach ($info as $detail) {
            $str .= "<tr><td>".$row_count."</td><td>".$detail['found_email']."</td></tr>";
            $row_count++;
        }
        $str .= "</table>";

        echo $str;
    }

    

     /**
    * method for SE Wise Details Download
    * @access public    
    * @return void
    */
    public function search_engine_search_detailw_download()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $search_engine_url_id = trim($this->input->post('download_details_se_url', true));
        $where['where'] = array('email.search_engine_url_id'=>$search_engine_url_id);
        $table = 'search_engine_search';
        $join = array(
            "email"         => "email.search_engine_url_id      =   search_engine_search.id,left",
            "searh_engine"  => "searh_engine.search_engine_name  =  search_engine_search.search_engine_name,left"
            );

        $info = $this->basic->get_data($table, $where, $select ='', $join);
        $fp = fopen("download/report/search_engine_details_email_{$this->user_id}_{$this->download_id}.csv", "w");
        $head=array("SL","Email");
        fputcsv($fp, $head);
        $write_info = array();
        $row_count=1;

        foreach ($info as  $value) {
            $write_info['sl'] = $row_count;
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
            $row_count++;
        }

        fclose($fp);
        $file_name = "download/report/search_engine_details_email_{$this->user_id}_{$this->download_id}.csv";
        $this->session->set_userdata('download_file_name', $file_name);
        echo $file_name;
    }

      

     /**
    * method to url wise details download
    * @access public    
    * @return void    
    */

    public function url_wise_details_download()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $url_id = trim($this->input->post('download_details_url', true));
        $where['where'] = array('email.url_id'=>$url_id);
        $table = 'url';
        $join = array("email" => "email.url_id = url.id,left");

        $info = $this->basic->get_data($table, $where, $select ='', $join);
        $fp = fopen("download/report/url_details_email.csv", "w");
        $head=array("SL","Email");
        fputcsv($fp, $head);
        $write_info = array();
        $row_count=1;

        foreach ($info as  $value) {
            $write_info['sl'] = $row_count;
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
            $row_count++;
        }

        fclose($fp);
        $file_name = "download/report/url_details_email.csv";
        $this->session->set_userdata('download_file_name', $file_name);
        echo $file_name;
    }

   /**
    * method to domain wise details download
    * @access public    
    * @return void    
    */

    public function domain_wise_details_download()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $domain_id = trim($this->input->post('download_details_url', true));
        $where['where'] = array('email.domain_id'=>$domain_id);
        $table = 'domain';
        $join = array("email" => "email.domain_id = domain.id,left");

        $info = $this->basic->get_data($table, $where, $select ='', $join);
        $fp = fopen("download/report/domain_details_email_{$this->user_id}_{$this->download_id}.csv", "w");
        $head=array("SL","Email");
        fputcsv($fp, $head);
        $write_info = array();
        $row_count=1;

        foreach ($info as  $value) {
            $write_info['sl'] = $row_count;
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
            $row_count++;
        }

        fclose($fp);
        $file_name = "download/report/domain_details_email_{$this->user_id}_{$this->download_id}.csv";
        echo $file_name;
    }


    /**
    * method to search engine wise details download
    * @access public    
    * @return void    
    */
    public function searchengine_wise_download()
    {
        $table = "search_engine_search";
        $join = array(
            "email"        => "email.search_engine_url_id	 	= 	search_engine_search.id,left",
            "searh_engine"  => "searh_engine.search_engine_name  =	search_engine_search.search_engine_name,left",
            "users" => "search_engine_search.user_id = users.id, left"
            );

        $selected_grid_data = $this->input->post('info', true);
        $search_engine_names = json_decode($selected_grid_data, true);
        $search_engine_names_array = array();
        foreach ($search_engine_names as  $value) {
            $search_engine_names_array[] = $value['search_engine_url_id'];
        }
        $where['where_in'] = array('search_engine_search.id' => $search_engine_names_array);

        $info = $this->basic->get_data($table, $where, $select ='', $join, $limit='', $start=null, $order_by='search_engine_search.search_engine_name asc');

        $fp = fopen("download/report/search_engine_wise_email_{$this->user_id}_{$this->download_id}.csv", "w");
        $head=array("Keyword", "Search Engine","Social Network", "Last Scraped Time","Email");
        fputcsv($fp, $head);
        $write_info = array();

        foreach ($info as  $value) {
            $write_info['search_keyword'] = $value['search_keyword'];
            $write_info['search_engine_name'] = $value['search_engine_name'];
            $write_info['search_in'] = $value['search_in'];
            // $write_info['name'] = $value['name'];
            $write_info['last_scraped_time'] = $value['last_scraped_time'];
            $write_info['email'] = $value['found_email'];

            fputcsv($fp, $write_info);
        }

        fclose($fp);
        $file_name = "download/report/search_engine_wise_email_{$this->user_id}_{$this->download_id}.csv";
        $this->session->set_userdata('download_file_name', $file_name);
        echo $file_name;
    }

    /**
    * method to view all email
    * @access public    
    * @return void    
    */
    public function all_email()
    {
        $this->load->database();
        $this->load->library('grocery_CRUD');
        $crud = new grocery_CRUD();
        $crud->set_theme('flexigrid');
        $crud->set_table('email');
        $crud->order_by('id');
        $crud->set_subject('Email List');
        $crud->fields('found_email', 'domain_id', 'url_id', 'search_engine_url_id');
        
        $crud->columns('found_email', 'domain_id', 'url_id', 'search_engine_url_id');

        $crud->display_as('found_email', 'Email');
        $crud->display_as('domain_id', 'Domain Name');
        $crud->display_as('url_id', 'URL');
        $crud->display_as('search_engine_url_id', 'Search Engine');
        // $crud->display_as('user_id', 'User Name'); 

        $crud->set_relation('user_id', 'users', 'name', 'id ASC');
        $crud->set_relation('url_id', 'url', 'url_name', 'id ASC');
        $crud->set_relation('domain_id', 'domain', 'domain_name', 'id ASC');
        $crud->set_relation('search_engine_url_id', 'searh_engine', 'search_engine_name', 'id ASC');

        $crud->unset_read();
        $crud->unset_edit();
        $crud->unset_delete();
        $crud->unset_add();
       /* $crud->unset_print();
        $crud->unset_export();*/

        $output = $crud->render();
        $data['output']=$output;
        $data['crud']=1;

        $this->_viewcontroller($data);
    }

     /**
    * Reset password form
    * @access public
    * @return void
    */
    public function reset_password_form()
    {
        $data['page_title'] = 'Password Reset';
        $data['body'] = 'admin/theme/password_reset_form';
        $this->_viewcontroller($data);
    }

    /**
    * Reset password action
    * @access public
    * @return void
    * @param int
    */
    public function reset_password_action()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            redirect('home/access_forbidden', 'location');
        }

        $this->form_validation->set_rules('old_password', '<b>Old Password</b>', 'trim|required|xss_clean');
        $this->form_validation->set_rules('new_password', '<b>New Password</b>', 'trim|required|xss_clean');
        $this->form_validation->set_rules('confirm_new_password', '<b>Confirm New Password</b>', 'trim|required|xss_clean|matches[new_password]');
        if ($this->form_validation->run() == false) {
            $this->reset_password_form();
        } else {
            $user_id = $this->user_id;
            $password = trim($this->input->post('old_password', true));
            $new_password = trim($this->input->post('new_password', true));
            $table = 'users';
            $where['where'] = array(
            'id' => $user_id,
            'password' => md5($password)
            );
            $select = array('email');
            if ($this->basic->get_data($table, $where, $select)) {
                $where = array(
                'id' => $user_id,
                'password' => md5($password)
                );
                $data = array('password' => md5($new_password));
                $this->basic->update_data($table, $where, $data);
                $this->session->set_userdata('logged_in', 0);
                $this->session->set_flashdata('reset_success', 'Please login with new password');
                redirect('home/login', 'location');
                // echo $this->session->userdata('reset_success');exit();
            } else {
                $this->session->set_userdata('error', 'The old password you have given is wrong!');
                return $this->reset_password_form();
            }
        }
    }
}
